#include "nxp_lpc11u6x.h"

#define DC1        (130)                               // duty cycle 1
#define DC2        (135)                               // duty cycle 2
#define hperiod    (180)

void SCT1_Init(void)
{
    LPC_SYSCON->PRESETCTRL  |= (1 << 10);              // de-assert SCT1 reset

    LPC_SCT1->CONFIG        |= (1 << 17);              // split timers, auto limit
    LPC_SCT1->CTRL_L        |= (1 << 4);               // configure SCT1 as BIDIR

    LPC_SCT1->MATCH[0].L     = hperiod;                // match on (half) PWM period
    LPC_SCT1->MATCHREL[0].L  = hperiod;
    LPC_SCT1->MATCH[1].L     = DC1;                    // match on duty cycle 1
    LPC_SCT1->MATCHREL[1].L  = DC1;
    LPC_SCT1->MATCH[2].L     = DC2;                    // match on duty cycle 2
    LPC_SCT1->MATCHREL[2].L  = DC2;

    LPC_SCT1->EVENT[0].STATE = 0xFFFFFFFF;             // event 0 happens in all states
    LPC_SCT1->EVENT[0].CTRL  = (1 << 0) | (1 << 12);   // match 1 (DC1) only condition

    LPC_SCT1->EVENT[1].STATE = 0xFFFFFFFF;             // event 1 happens in all states
    LPC_SCT1->EVENT[1].CTRL  = (2 << 0) | (1 << 12);   // match 2 (DC2) only condition

    LPC_SCT1->OUT[0].SET     = (1 << 0);               // event 0 sets   OUT0 (blue LED)
    LPC_SCT1->OUT[0].CLR     = (1 << 0);               // event 0 clears OUT0 (blue LED)
    LPC_SCT1->OUT[1].SET     = (1 << 1);               // event 1 sets   OUT1 (red LED)
    LPC_SCT1->OUT[1].CLR     = (1 << 1);               // event 1 clears OUT1 (red LED)
    LPC_SCT1->RES           |= 0x0000000F;             // toggle OUT0 and OUT1 on conflict
    LPC_SCT1->OUTPUT        |= 1;                      // default set OUT0 and and clear OUT1

	LPC_SCT1->CTRL_L        &= ~(1 << 2);              // start timer
}
